// Przyklad uzycia pol z poziomu SMLa

namespace Fields
{
public class C
{
  // Pola statyczne

  // Najpierw pole constant; bedzie ono jako
  //   val static_const_field : int
  public const int static_const_field = 12345;

  // Teraz pole readonly; bedzie ono jako
  //   val static_readonly_field : string option
  public static readonly string static_readonly_field 
	= System.String.Concat("Hello, ", "World");

  // Pole zmienne; bedzie ono jako wygodny skrot typu 
  // opisujacy pole jako typ przechowujacy dane
  //   type static_field = (int, (C, static_field) static) reference
  // razem z referencja tego typu
  //   val static_field : static_field
  public static int static_field = 23;

  // Pola zalezne od instancji
  // Pole readonly; bedzie ono jako
  //   val readonly_field : C -> string option
  // i dla jakiegos c : C,
  //	c.#readonly_field : string option
  public readonly string inst_readonly_field;

  // Na koniec pole zmienne; bedzie ono wystepowac jako 
  // wygodny skrot typu opisujacy pole jako typ przechowujacy dane
  //   type instfield = (int, (C, inst_field) field) reference 
  // i dla jakiegos c : C, element #inst_field jest zdefiniowany 
  // jako referencja tego typu
  //	c.#inst_field : inst_field
  public int inst_field;

  public C(string s, int i)
  {
    inst_readonly_field = System.String.Concat("Hello, ", s);
    inst_field = i;
  }
}
}
